<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <title lang="en">Výpis převýšení a virtuálního přechodu</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <h2 lang="en">Výpis převýšení a virtuálního přechodu</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>

                            <xsl:for-each select="GeometryProject">
                                <table class="margin" cellpadding="2" width="90%">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Projekt:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Popis:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Poslední uprava:&#xa0; </th>
                                            <td align="left" colspan="2">
                                                <xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="font-size: 80%">Koeficient vstupního rastru:&#xa0; </th>
                                            <td align="left" style="font-size: 80%">
                                                <xsl:value-of select="../@inputGridScaleFactor" />
                                            </td>
                                            <td align="right" lang="en" style="font-size: 80%">
                                                <strong>Poznámka:&#xa0; </strong>Všechny jednotky tohoto výpisu jsou
                                                <xsl:if test="//@linearUnits = 'Imperial'">ve stopách, </xsl:if>
                                                <xsl:if test="//@linearUnits = 'Metric'">v metrech, </xsl:if>
                                                pokud není specifikováno jinak.
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr />

                                <table cellpadding="1" width="100%">
                                    <xsl:for-each select="HorizontalAlignment[*/CantAlignment]">
                                        <tr>
                                            <th align="right" lang="en" width="20%"><br/>Směrové řešení:&#xa0; </th>
                                            <td align="left" valign="bottom" width="80%"><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en" style="white-space:nowrap;">Směrové Popis:&#xa0; </th>
                                            <td align="left"><xsl:value-of select="@description"/></td>
                                        </tr>
                                        <tr>
                                            <th align="right" lang="en">Směrové Styl:&#xa0; </th>
                                            <td align="left"><xsl:value-of select="@style"/></td>
                                        </tr>
                                        <xsl:for-each select="Superelevation/CantAlignment">
                                            <tr>
                                                <th align="right" lang="en"><br/>Převýšení Název:&#xa0; </th>
                                                <td align="left" valign="bottom"><xsl:value-of select="@name"/></td>
                                            </tr>
                                            <tr>
                                                <th align="right" lang="en">Převýšení Popis:&#xa0; </th>
                                                <td align="left"><xsl:value-of select="@description"/></td>
                                            </tr>
                                            <tr>
                                                <td colspan="14">
                                                    <table width="100%">
                                                        <xsl:if test="//@linearUnits = 'Imperial'">
                                                            <tr>
                                                                <th class="underline" lang="en" valign="bottom">Typ</th>
                                                                <th class="underline" lang="en" valign="bottom">Staničení</th>
                                                                <th class="underline" lang="en" valign="bottom">Rychlost<br/>(m/h)</th>
                                                                <th class="underline" lang="en" valign="bottom">Poloměr</th>
                                                                <th class="underline" lang="en" valign="bottom">Délka</th>
                                                                <th class="underline" lang="en" valign="bottom">Přechod</th>
                                                                <th class="underline" lang="en" valign="bottom">Je virtuální</th>
                                                                <th class="underline" lang="en" valign="bottom">Teoretické<br/>převýšení<br/>(in)</th>
                                                                <th class="underline" lang="en" valign="bottom">Projektové<br/>převýšení<br/>(in)</th>
                                                                <th class="underline" lang="en" valign="bottom">Nedostatek<br/>převýšení<br/>(in)</th>
                                                                <th class="underline" lang="en" valign="bottom">Nevyrovnané<br/>příčné<br/>zrychlení<br/>(ft/s*s)</th>
                                                                <th class="underline" lang="en" valign="bottom">Časová<br/>změna<br/>převýšení<br/>(in/s)</th>
                                                                <th class="underline" lang="en" valign="bottom">Časová<br/>změna<br/>nedostatku přev.<br/>(in/s)</th>
                                                                <th class="underline" lang="en" valign="bottom">Součinitel sklonu<br/>vzestupnice</th>
                                                            </tr>
                                                        </xsl:if>
                                                        <xsl:if test="//@linearUnits = 'Metric'">
                                                            <tr>
                                                                <th class="underline" lang="en" valign="bottom">Typ</th>
                                                                <th class="underline" lang="en" valign="bottom">Staničení</th>
                                                                <th class="underline" lang="en" valign="bottom">Rychlost<br/>(km/h)</th>
                                                                <th class="underline" lang="en" valign="bottom">Poloměr</th>
                                                                <th class="underline" lang="en" valign="bottom">Délka</th>
                                                                <th class="underline" lang="en" valign="bottom">Přechod</th>
                                                                <th class="underline" lang="en" valign="bottom">Je virtuální</th>
                                                                <th class="underline" lang="en" valign="bottom">Teoretické<br/>převýšení<br />(mm)</th>
                                                                <th class="underline" lang="en" valign="bottom">Projektové<br/>převýšení<br/>(mm)</th>
                                                                <th class="underline" lang="en" valign="bottom">Nedostatek<br/>převýšení<br/>(mm)</th>
                                                                <th class="underline" lang="en" valign="bottom">Nevyrovnané<br/>příčné<br/>zrychlení<br/>(m/s*s)</th>
                                                                <th class="underline" lang="en" valign="bottom">Časová<br/>změna<br/>převýšení<br/>(mm/s)</th>
                                                                <th class="underline" lang="en" valign="bottom">Časová<br/>změna<br/>nedostatku přev.<br/>(mm/s)</th>
                                                                <th class="underline" lang="en" valign="bottom">Součinitel sklonu<br/>vzestupnice</th>
                                                            </tr>
                                                        </xsl:if>

                                                        <xsl:for-each select="Cant">
                                                            <tr>
                                                                <td align="left"><xsl:value-of select="Start/@type"/></td>
                                                                <td align="right" style="white-space:nowrap;">
                                                                    <xsl:value-of select="cif:stationFormat(number(Start/station/@externalStation), string(Start/station/@externalStationName))"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:formatNumber(number(@designSpeed), 0)"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:distanceFormat(number(@radius))"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:distanceFormat(number(@length))"/>
                                                                </td>
                                                                <td align="center"><xsl:value-of select="@transitionType"/></td>
                                                                <td align="center"><xsl:value-of select="@isVirtualTransition"/></td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:formatNumber(number(@equilibriumCant))"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:formatNumber(number(@appliedCant))"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:formatNumber(number(@cantDeficiency))"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:distanceFormat(number(@nonLateralAcceleration))"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:formatNumber(number(@appliedCantRateOfChange))"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:formatNumber(number(@cantDeficiencyRateOfChange))"/>
                                                                </td>
                                                                <td align="right">
                                                                    <xsl:value-of select="cif:formatNumber(number(@appliedGradient), 0)"/>
                                                                </td>
                                                            </tr>
                                                        </xsl:for-each>
                                                        <tr><td colspan="12">&#xa0;</td></tr>
                                                    </table>
                                                </td>
                                            </tr>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>

    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Notes</h4>
            <p class="normal1" lang="en">
                Musíte vybrat nejméně jedno směrové řešení v poli <em>Zahrnout</em> v dialogu
                <em>Nástroje &gt; XML Výpisy &gt; Geometrie</em>.
            </p>
            <p class="normal1" lang="en">
                Pro tento výpis také musíte zapnout volbu <em>Včetně převýšení</em> a vybrat buď  
                <em>Vše</em> nebo <em>Aktivní</em>.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
